/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.client.ModKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.client.config.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.client.config.ConfigUtil;
import com.nemonotfound.nemos.inventory.sorting.client.gui.components.AbstractSortButton;
import com.nemonotfound.nemos.inventory.sorting.factory.ButtonCreator;
import com.nemonotfound.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortAlphabeticallyButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortAlphabeticallyDescendingButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.interfaces.GuiPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_485;
import net.minecraft.class_490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_490.class})
public abstract class InventoryScreenMixin
extends class_485<class_1723>
implements GuiPosition {
    @Unique
    private final Map<class_304, AbstractSortButton> nemosInventorySorting$keyMappingButtonMap = new HashMap<class_304, AbstractSortButton>();

    public InventoryScreenMixin(class_1723 menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    public void init(CallbackInfo ci) {
        SortAlphabeticallyButtonFactory sortAlphabeticallyButtonFactory = SortAlphabeticallyButtonFactory.getInstance();
        SortAlphabeticallyDescendingButtonFactory sortAlphabeticallyDescendingButtonFactory = SortAlphabeticallyDescendingButtonFactory.getInstance();
        DropAllButtonFactory dropAllButtonFactory = DropAllButtonFactory.getInstance();
        List<ComponentConfig> configs = ConfigUtil.readConfigs();
        this.nemosInventorySorting$createButton(configs, Constants.SORT_ALPHABETICALLY_DESCENDING_INVENTORY, ModKeyMappings.SORT_ALPHABETICALLY_DESCENDING_INVENTORY.get(), sortAlphabeticallyDescendingButtonFactory, Constants.X_OFFSET_SORT_ALPHABETICALLY_DESCENDING_INVENTORY, Constants.Y_OFFSET_INVENTORY, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createButton(configs, Constants.SORT_ALPHABETICALLY_INVENTORY, ModKeyMappings.SORT_ALPHABETICALLY_INVENTORY.get(), sortAlphabeticallyButtonFactory, Constants.X_OFFSET_SORT_ALPHABETICALLY_INVENTORY, Constants.Y_OFFSET_INVENTORY, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createButton(configs, Constants.DROP_ALL_INVENTORY, ModKeyMappings.DROP_ALL_INVENTORY.get(), dropAllButtonFactory, Constants.X_OFFSET_DROP_ALL_INVENTORY, Constants.Y_OFFSET_INVENTORY, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        for (AbstractSortButton button : this.nemosInventorySorting$keyMappingButtonMap.values()) {
            this.method_37063((class_364)button);
        }
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configsList, String componentName, class_304 keyMapping, ButtonCreator buttonCreator, int defaultXOffset, int defaultYOffset, int defaultWidth, int defaultHeight) {
        Optional<ComponentConfig> optionalComponentConfig = ConfigUtil.getConfigs(configsList, componentName);
        if (optionalComponentConfig.isEmpty()) {
            this.nemosInventorySorting$createButton(keyMapping, buttonCreator, defaultXOffset, defaultYOffset, defaultWidth, defaultHeight);
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int yOffset = config.yOffset() != null ? config.yOffset() : defaultYOffset;
        this.nemosInventorySorting$createButton(keyMapping, buttonCreator, config.xOffset(), yOffset, config.width(), config.height());
    }

    @Unique
    private void nemosInventorySorting$createButton(class_304 keyMapping, ButtonCreator buttonCreator, int xOffset, int yOffset, int width, int height) {
        int nemosInventorySorting$startIndex = 9;
        int nemosInventorySorting$endIndex = 36;
        AbstractSortButton sortButton = buttonCreator.createButton(nemosInventorySorting$startIndex, nemosInventorySorting$endIndex, this.field_2776, this.field_2800, xOffset, yOffset, width, height, (class_465<?>)this);
        this.nemosInventorySorting$keyMappingButtonMap.put(keyMapping, sortButton);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((class_304)entry.getKey()).method_1417(keyCode, scanCode)).findFirst();
        if (keyCode == 340) {
            this.nemosInventorySorting$updateToolTips(true);
        } else {
            optionalButtonEntry.ifPresent(entry -> {
                AbstractSortButton button = (AbstractSortButton)((Object)((Object)entry.getValue()));
                button.method_25354(class_310.method_1551().method_1483());
                button.method_25348(0.0, 0.0);
            });
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.nemosInventorySorting$updateToolTips(false);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((class_304)entry.getKey()).method_1433(button)).findFirst();
        optionalButtonEntry.ifPresent(entry -> {
            AbstractSortButton sortButton = (AbstractSortButton)((Object)((Object)entry.getValue()));
            sortButton.method_25354(class_310.method_1551().method_1483());
            sortButton.method_25348(0.0, 0.0);
        });
        return super.method_25402(mouseX, mouseY, button);
    }

    @Unique
    private void nemosInventorySorting$updateToolTips(boolean isShiftDown) {
        for (AbstractSortButton button : this.nemosInventorySorting$keyMappingButtonMap.values()) {
            button.setIsShiftKeyDown(isShiftDown);
            button.setTooltip(this.method_17577());
        }
    }

    @Override
    public int nemosInventorySorting$getLeftPos() {
        return this.field_2776;
    }
}

